' Employee est la classe de base de cette hirarchie.
' Elle sert  conserver les donnes communes  tous les type employee.
Public  Class Employee

    ' Donnes dans l'tat protg.
    ' Les classes filles peuvent accder directement
    '  ces informations. Les utilisateurs de l'objet ne le peuvent pas.
    Protected mFullName As String
    Protected mEmpID As Integer
    Protected mCurrPay As Double
    Protected mSSN As String

    ' Champ en lecture seule.
    Public ReadOnly SSNField As String = "111-11-1111"

    ' Donnes partages.
    Private Shared CompName As String

    ' Augmenter la paie de cet employ.
    Public Overridable Sub GiveBonus(ByVal amount As Double)
        mCurrPay += amount
    End Sub

    ' Mthode d'accs et de modification du prnom.
    Public Function GetFullName() As String
        Return mFullName
    End Function

    Public Sub SetFullName(ByVal n As String)
        ' Enlever tous les caractres illgaux (!,@,#,$,%),
        ' Vrifier la taille maximum ou la case avant toute affectation.
        mFullName = n
    End Sub

    Public Property EmpID() As Integer
        Get
            Return mEmpID
        End Get
        Set(ByVal Value As Integer)
            ' Uniquement pour dmonstration. Dcommenter pour tester.
            Console.WriteLine("value est une instance de : {0}", _
                    Value.GetType())

            Console.WriteLine("value sous forme de chane : {0}", _
                    Value.ToString())
            mEmpID = Value
        End Set
    End Property

    ' ERREUR! Dj dfini via la proprit SSN!
    'Public Function get_SSN() As String
    '    Return SSN
    'End Function

    'Public Sub set_SSN(ByVal newVal As String)
    '    SSN = newVal
    'End Sub

    ' Proprit pour la donne empID.
    Public Property Pay() As Double
        Get
            Return mCurrPay
        End Get
        Set(ByVal Value As Double)
            mCurrPay = Value
        End Set
    End Property

    Public Property SSN() As String
        Get
            Return mSSN
        End Get
        Set(ByVal Value As String)
            mSSN = Value
        End Set
    End Property

    ' Si vous surchargez le constructeur par dfaut 
    ' vous devez le rdfinir explicitement, sinon vous ne
    ' pourrez pas crer une instance en utilisant la forme :
    ' Employee e = new Employee();

    ' Constructeur par dfaut.
    Public Sub New()
    End Sub

    ' Constructeur personnalis
    Public Sub New(ByVal FullName As String, ByVal empID As Integer, _
    ByVal currPay As Double, ByVal ssn As String)
        ' Affecter les donnes internes d'tat.
        ' notez l'utilisation du mot clef 'this'
        Me.mFullName = FullName
        Me.mEmpID = empID
        Me.mCurrPay = currPay
        Me.mSSN = ssn
    End Sub

    Shared Sub New()
        CompName = "Intertech, Inc"
    End Sub

    ' Si l'utilisateur utilise ce constructeur, on lance la version
    ' avec 4 arguments en utilisant des valeurs arbitraires...
    Public Sub New(ByVal fullName As String)
        Me.New(fullName, 3333, 0, "")
    End Sub

    ' Afficher l'tat.
    Public Overridable Sub DisplayStats()
        Console.WriteLine("Nom : {0}", mFullName)
        Console.WriteLine("Salaire : {0}", mCurrPay)
        Console.WriteLine("ID : {0}", mEmpID)
        Console.WriteLine("SSN : {0}", mSSN)
    End Sub

    ' Une proprit statique.
    Public Shared Property Company() As String
        Get
            Return CompName
        End Get
        Set(ByVal Value As String)
            CompName = Value
        End Set
    End Property

    ' Un proprit en lecture seule.
    Public ReadOnly Property ReadOnlySSN() As String
        Get
            Return mSSN
        End Get
    End Property

    ' Une mthode surcharge.
    Public Sub GetStartDate(ByVal id As Integer)
        ' Rechercher la date d'embauche en utilisant l'ID d'un employ.
    End Sub
    Public Sub GetStartDate(ByVal ssn As String)
        ' Rechercher la date d'embauche en utilisant le SSN.
    End Sub
End Class